@extends('backEnd.master')
@section('title')
@lang('inventory.supplier_list')
@endsection
@section('mainContent')
@push('css')
    <style>
        .invalid-feedback {
            display: inline-block !important;
        }
    </style>
@endpush
<section class="sms-breadcrumb mb-40 white-box">
    <div class="container-fluid">
        <div class="row justify-content-between">
            <h1>@lang('inventory.supplier_list')</h1>
            <div class="bc-pages">
                <a href="{{route('dashboard')}}">@lang('common.dashboard')</a>
                <a href="#">@lang('inventory.inventory')</a>
                <a href="#">@lang('inventory.supplier_list')</a>
            </div>
        </div>
    </div>
</section>
<section class="admin-visitor-area up_st_admin_visitor">
    <div class="container-fluid p-0">
         @if(isset($editData))
          @if(userPermission(329))
           
        <div class="row">
            <div class="offset-lg-10 col-lg-2 text-right col-md-12 mb-20">
                <a href="{{route('suppliers')}}" class="primary-btn small fix-gr-bg">
                    <span class="ti-plus pr-2"></span>
                    @lang('common.add')
                </a>
            </div>
        </div>
        @endif
        @endif
        <div class="row">
            
            <div class="col-lg-3">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="main-title">
                            <h3 class="mb-30">@if(isset($editData))
                                    @lang('inventory.edit_supplier')
                                @else
                                    @lang('inventory.add_supplier')
                                @endif
                               
                            </h3>
                        </div>
                        @if(isset($editData))
                        {{ Form::open(['class' => 'form-horizontal', 'files' => true, 'route' => array('suppliers-update',$editData->id), 'method' => 'PUT', 'enctype' => 'multipart/form-data']) }}
                        @else
                         @if(userPermission(329))
                        {{ Form::open(['class' => 'form-horizontal', 'files' => true, 'route' => 'suppliers',
                        'method' => 'POST', 'enctype' => 'multipart/form-data']) }}
                        @endif
                        @endif
                        <div class="white-box">
                            <div class="add-visitor">
                                <div class="row">
                                   <div class="col-lg-12 mb-30">
                                        <div class="input-effect">
                                            <input class="primary-input form-control{{ $errors->has('company_name') ? ' is-invalid' : '' }}"
                                            type="text" name="company_name" autocomplete="off" value="{{isset($editData)? $editData->company_name : old('company_name') }}">
                                            <label> @lang('inventory.company_name') <span>*</span> </label>
                                            <span class="focus-border"></span>
                                            @if ($errors->has('company_name'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('company_name') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-lg-12 mb-30">
                                        <div class="input-effect">
                                            <textarea class="primary-input form-control{{$errors->has('company_address') ? 'is-invalid' : '' }}" cols="0" rows="4" name="company_address" id="company_address">{{isset($editData) ? $editData->company_address : old('company_address')}}</textarea>
                                            <label> @lang('inventory.company_address') * <span></span> </label>
                                            <span class="focus-border"></span>
                                            @if ($errors->has('company_address'))
                                            <span class="invalid-feedback custom-server-feedback" role="alert">
                                                <strong>{{ $errors->first('company_address') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-lg-12 mb-30">
                                        <div class="input-effect">
                                            <input class="primary-input form-control{{ $errors->has('contact_person_name') ? ' is-invalid' : '' }}"
                                            type="text" name="contact_person_name" autocomplete="off" value="{{isset($editData)? $editData->contact_person_name : old('contact_person_name') }}">
                                            <label>@lang('inventory.contact_person_name') <span>*</span></label>
                                            <span class="focus-border"></span>
                                            @if ($errors->has('contact_person_name'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('contact_person_name') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-lg-12 mb-30">
                                        <div class="input-effect">
                                            <input class="primary-input form-control{{ $errors->has('contact_person_mobile') ? ' is-invalid' : '' }}"
                                            type="tel" oninput="phoneCheck(this)" name="contact_person_mobile" autocomplete="off" value="{{isset($editData)? $editData->contact_person_mobile : old('contact_person_mobile') }}">
                                            <label>@lang('inventory.contact_person_mobile')</label>
                                            <span class="focus-border"></span>
                                            @if ($errors->has('contact_person_mobile'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('contact_person_mobile') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mb-30">
                                        <div class="input-effect">
                                            <input oninput="emailCheck(this)" class="primary-input form-control{{ $errors->has('contact_person_email') ? ' is-invalid' : '' }}"
                                            type="email" name="contact_person_email" autocomplete="off" value="{{isset($editData)? $editData->contact_person_email : old('contact_person_email') }}">
                                            <label>@lang('inventory.contact_person_email') <span class="email_info"></span></label>
                                            <span class="focus-border"></span>
                                        </div>
                                    </div>

                                    <div class="col-lg-12 mb-30">
                                        <div class="input-effect">
                                            <textarea class="primary-input form-control" cols="0" rows="4" name="description" id="description">{{isset($editData) ? $editData->description : old('description')}}</textarea>
                                            <label>@lang('common.description') <span></span> </label>
                                            <span class="focus-border textarea"></span>
                                        </div>
                                    </div>
                                </div>
                                	  @php 
                                  $tooltip = "";
                                  if(userPermission(329)){
                                        $tooltip = "";
                                    }else{
                                        $tooltip = "You have no permission to add";
                                    }
                                @endphp
                                <div class="row mt-40">
                                    <div class="col-lg-12 text-center">
                                            <button class="primary-btn fix-gr-bg submit" data-toggle="tooltip" title="{{$tooltip}}">
                                            <span class="ti-check"></span>
                                            @if(isset($editData))
                                                @lang('common.update')
                                            @else
                                                @lang('common.save')
                                            @endif
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>

            <div class="col-lg-9">
               
              <div class="row">
                <div class="col-lg-4 no-gutters">
                    <div class="main-title">
                        <h3 class="mb-0"> @lang('inventory.supplier_list')</h3>
                    </div>
                </div>
            </div>

            <div class="row">

                <div class="col-lg-12">
                    <table id="table_id" class="display school-table" cellspacing="0" width="100%">
                        <thead>
                           
                            <tr>
                                <th> @lang('inventory.supplier_name')</th>
                                <th> @lang('inventory.company_name')</th>
                                <th> @lang('inventory.company_address')</th>
                                <th> @lang('common.email')</th>
                                <th> @lang('common.mobile')</th>
                                <th> @lang('common.action')</th>
                            </tr>
                        </thead>

                        <tbody>
                            @if(isset($suppliers))
                            @foreach($suppliers as $value)
                            <tr>

                                <td>{{$value->contact_person_name}}</td>
                                <td>{{$value->company_name}}</td>
                                <td>{{$value->company_address}}</td>
                                <td>{{$value->contact_person_email}}</td>
                                <td>{{$value->contact_person_mobile}}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn dropdown-toggle" data-toggle="dropdown">
                                            @lang('common.select')
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                        @if(userPermission(330) )
                                            <a class="dropdown-item" href="{{route('suppliers-edit',$value->id)}}"> @lang('common.edit')</a>
                                        @endif
                                        @if(userPermission(331))
                                            <a class="deleteUrl dropdown-item" data-modal-size="modal-md" title="@lang('inventory.delete_supplier')" href="{{route('delete-supplier-view',$value->id)}}"> @lang('common.delete')</a>
                                        @endif
                                        </div>
                                    </div>
                                </td>
                            </tr>

                            @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</section>
@endsection
